package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GoogleAuthProvider;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.MainActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivitySignupBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.LoginResponse;
import app.firezone.synk.network.model.User;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SignupActivity extends AppCompatActivity {

    ActivitySignupBinding binding;
    GoogleSignInClient mGoogleSignInClient;
    int RC_SIGN_IN = 11;
    FirebaseAuth mAuth;
    FirebaseUser user;

    private MyApi myApi;

    EditText phoneNo, referCodes;
    ProgressDialog dialog;
    Dialog dialog2;
    long referBonus;

    EditText nameEt, emailET, phoneNo_Et, passwordEt, referralcode;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivitySignupBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        nameEt = findViewById(R.id.namesEdt);
        emailET = findViewById(R.id.emailsEdt);
        referralcode = findViewById(R.id.referralcodeEdt);
        passwordEt = findViewById(R.id.passwordEdts);
        phoneNo_Et = findViewById(R.id.phoneno);

        mAuth = FirebaseAuth.getInstance();

        dialog = new ProgressDialog(SignupActivity.this);
        dialog.setTitle("User Account Creating ");
        dialog.setMessage("Please Wait...");
        dialog.setCancelable(false);

        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
                .requestIdToken(getString(R.string.client_id))
                .requestEmail()
                .build();

        mGoogleSignInClient = GoogleSignIn.getClient(this, gso);

        binding.googleBtn.setOnClickListener(view -> initiateGoogleLogin());

        binding.alreadyAccount.setOnClickListener(v -> {
            startActivity(new Intent(getApplicationContext(), LoginActivity.class));
            finish();
        });

        binding.linkTxt.setMovementMethod(LinkMovementMethod.getInstance());

        binding.btnSignUp.setOnClickListener(v -> {
            String name = nameEt.getText().toString();
            String email = emailET.getText().toString().trim();
            String password = passwordEt.getText().toString();
            String phoneno = phoneNo_Et.getText().toString().trim();
            String username = referralcode.getText().toString();

            if (TextUtils.isEmpty(name)) {
                nameEt.setError("Name is Required");
                return;
            }
            if (TextUtils.isEmpty(email)) {
                emailET.setError("Email is Required");
                return;
            }
            if (TextUtils.isEmpty(phoneno)) {
                phoneNo_Et.setError("Phone no. is Required");
                return;
            }
            if (TextUtils.isEmpty(password)) {
                passwordEt.setError("Password is Required");
                return;
            }
            if (password.length() < 6) {
                passwordEt.setError("Password must be 6 characters or more");
                return;
            }

            dialog.show();
            checkEmailExists(email);
        });
    }

    private void initiateGoogleLogin() {
        Intent signInIntent = mGoogleSignInClient.getSignInIntent();
        startActivityForResult(signInIntent, RC_SIGN_IN);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == RC_SIGN_IN) {
            Task<GoogleSignInAccount> task = GoogleSignIn.getSignedInAccountFromIntent(data);
            handleSignInResult(task);
        }
    }

    private void handleSignInResult(Task<GoogleSignInAccount> completedTask) {
        try {
            GoogleSignInAccount account = completedTask.getResult(ApiException.class);
            if (account != null) {
                checkUserExistsInDatabase(account.getEmail(), account.getIdToken());
            }
        } catch (ApiException e) {
            Toast.makeText(this, "Google sign-in failed.", Toast.LENGTH_SHORT).show();
        }
    }

    private void checkUserExistsInDatabase(String email, String idToken) {
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        Call<CheckEmailResponse> call = myApi.checkEmailExists(email);
        call.enqueue(new Callback<CheckEmailResponse>() {
            @Override
            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        Toast.makeText(SignupActivity.this, "Account already exists", Toast.LENGTH_SHORT).show();
                    } else {
                        authWithGoogle(idToken);
                    }
                }
            }

            @Override
            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                Toast.makeText(SignupActivity.this, "Failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    void authWithGoogle(String idToken) {
        AuthCredential credential = GoogleAuthProvider.getCredential(idToken, null);
        mAuth.signInWithCredential(credential)
                .addOnCompleteListener(task -> {
                    if (task.isSuccessful()) {
                        user = mAuth.getCurrentUser();
                        showPhoneAndReferralDialog();
                    } else {
                        Toast.makeText(this, "Google Auth Failed", Toast.LENGTH_SHORT).show();
                    }
                });
    }

    private void checkEmailExists(String email) {
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        Call<CheckEmailResponse> call = myApi.checkEmailExists(email);
        call.enqueue(new Callback<CheckEmailResponse>() {
            @Override
            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        dialog.dismiss();
                        Toast.makeText(SignupActivity.this, "Account already exists", Toast.LENGTH_SHORT).show();
                    } else {
                        createUserByEmailPass();
                       // Toast.makeText(SignupActivity.this, "Account not exists", Toast.LENGTH_SHORT).show();
                    }
                }
            }

            @Override
            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                Toast.makeText(SignupActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void createUserByEmailPass() {
        String profile = getString(R.string.app_icon);
        String name = nameEt.getText().toString().trim();
        String username = name;
        String email = emailET.getText().toString().trim();
        String password = passwordEt.getText().toString().trim();
        String referred = referralcode.getText().toString().trim();
        String phoneno = phoneNo_Et.getText().toString().trim();
        long depoBalance = 0, bonusBalance = 5, winBalance = 0, totalKills = 0, totalEarning = 0, matchPlayed = 0;
        String referCode = email.substring(0, email.lastIndexOf("@")).replace(".", "");
        String joinedDate = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).format(new Date());
        String status = "Active", loginVia = "0";

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<User> call = myApi.registerUser(username, name, email, password, phoneno, profile,
                depoBalance, winBalance, bonusBalance, referred, joinedDate, loginVia,
                status, totalKills, matchPlayed, referCode, totalEarning);

        call.enqueue(new Callback<User>() {
            @Override
            public void onResponse(Call<User> call, Response<User> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(SignupActivity.this, "Account Created", Toast.LENGTH_SHORT).show();

                    loginAfterSignup(email, password);

                    if (!referred.isEmpty()) {
                        handleReferral(referred);
                    }
                } else {
                    try {
                        String errorBody = response.errorBody().string();
                        Log.e("SignupError", errorBody); // Server-side Laravel message
                        Toast.makeText(SignupActivity.this, "Signup Failed:\n" + errorBody, Toast.LENGTH_LONG).show();
                    } catch (Exception e) {
                        Toast.makeText(SignupActivity.this, "Signup Failed: " + response.message(), Toast.LENGTH_SHORT).show();
                        Log.e("Signup Exception", response.message());
                    }
                }
            }


            @Override
            public void onFailure(Call<User> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(SignupActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void showPhoneAndReferralDialog() {
        dialog2 = new Dialog(SignupActivity.this);
        dialog2.setContentView(R.layout.mobile_refer_layout);
        dialog2.setCancelable(false);

        phoneNo = dialog2.findViewById(R.id.phoneno);
        referCodes = dialog2.findViewById(R.id.referCodeEdt);
        Button verifyBtn = dialog2.findViewById(R.id.verifyBtn);

        verifyBtn.setOnClickListener(view -> {
            String phone = phoneNo.getText().toString();
            String referby = referCodes.getText().toString();

            if (TextUtils.isEmpty(phone)) {
                phoneNo.setError("Enter Phone number");
                return;
            }
            dialog2.dismiss();
            createUserByGoogle(phone, referby);
        });

        dialog2.show();
        dialog2.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        dialog2.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog2.getWindow().setGravity(Gravity.BOTTOM);
    }

    private void createUserByGoogle(String phone, String referby) {
        String profile = user.getPhotoUrl().toString();
        String name = user.getDisplayName();
        String username = name;
        String email = user.getEmail();
        String password = user.getUid();
        String joinedDate = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).format(new Date());
        long depoBalance = 0, bonusBalance = 5, winBalance = 0, totalKills = 0, totalEarning = 0, matchPlayed = 0;
        String referCode = email.substring(0, email.lastIndexOf("@")).replace(".", "");
        String status = "Active", loginVia = "1";

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<User> call = myApi.registerUser(username, name, email, password, phone, profile,
                depoBalance, winBalance, bonusBalance, referby, joinedDate, loginVia,
                status, totalKills, matchPlayed, referCode, totalEarning);

        call.enqueue(new Callback<User>() {
            @Override
            public void onResponse(Call<User> call, Response<User> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(SignupActivity.this, "Google Account Created", Toast.LENGTH_SHORT).show();
                    loginAfterSignup(email, password);

                    if (!referby.isEmpty()) {
                        handleReferral(referby);
                    }
                } else {
                    Toast.makeText(SignupActivity.this, "Google Signup Failed", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<User> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(SignupActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void loginAfterSignup(String email, String password) {
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<LoginResponse> call = myApi.loginUser(email, password);
        call.enqueue(new Callback<LoginResponse>() {
            @Override
            public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    LoginResponse res = response.body();
                    SharedPrefManager pref = SharedPrefManager.getInstance(SignupActivity.this);
                    pref.saveUserId(res.getUserId());
                    pref.saveAccessToken(res.getAccess_token());

                    startActivity(new Intent(SignupActivity.this, MainActivity.class));
                    finish();
                } else {
                    Toast.makeText(SignupActivity.this, "Login failed: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<LoginResponse> call, Throwable t) {
                Toast.makeText(SignupActivity.this, "Login error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void handleReferral(String referCode) {
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.checkReferral(referCode);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(SignupActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable t) {
                Toast.makeText(SignupActivity.this, "Referral check failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
}
